# WHILE

交易过程 trade 中有一个遍历交易项的循环，当累计的总交易额 `@total_price` 超过 20000， 这个循环就结束

```mysql
-- ...
trade: LOOP
    -- ... 
    if @total_price > 20000 then
        LEAVE trade;
    else
        ITERATE trade;
    end if;
    -- ...
end LOOP trace;
```

现在 Joe 想要用 `WHILE` 简化这个 `LOOP` 循环，他应该怎么做？

## 答案

```mysql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE trade;
```

## 选项

### A

```mysql
trade: DO 
    -- 省略交易过程
WHILE @total_price > 20000;
```

### B

```mysql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE trade;
```

### C

```mysql
trade: WHILE @total_price > 20000 DO
    -- 省略交易过程
END WHILE trade;
```

### D

```mysql
trade: WHILE @total_price > 20000
    -- 省略交易过程
END WHILE;
```
